package ru.yandex.solomon.coremon.client;

import java.util.Optional;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.discovery.cluster.ClusterMapper;
import ru.yandex.grpc.conf.ClientOptionsFactory;
import ru.yandex.grpc.conf.GrpcConfigurationContext;
import ru.yandex.solomon.config.protobuf.rpc.TRpcClientConfig;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.util.host.HostUtils;


/**
 * @author Sergey Polovko
 */
@Configuration
@Import({
        GrpcConfigurationContext.class
})
public class CoremonClientContext {

    @Bean
    CoremonClient coremonClient(
        @Qualifier("ClientId") Optional<String> clientId,
        @Qualifier("CoremonClientConfig") TRpcClientConfig config,
        ThreadPoolProvider threadPoolProvider,
        ClusterMapper clusterMapper,
        ClientOptionsFactory clientOptionsFactory)
    {
        if (!config.hasGrpcConfig()) {
            throw new IllegalStateException("bad CoremonClientConfig");
        }
        return new CoremonClientImpl(clientId.orElseGet(HostUtils::getShortName), config.getGrpcConfig(), threadPoolProvider, clusterMapper, clientOptionsFactory);
    }
}
