package ru.yandex.solomon.coremon.client;

import com.google.common.collect.ImmutableList;

/**
 * @author Sergey Polovko
 */
public class ShardInfo {

    private final String shardId;
    private final int numId;
    private final ImmutableList<String> hosts;

    public ShardInfo(String shardId, int numId, ImmutableList<String> hosts) {
        this.shardId = shardId;
        this.numId = numId;
        this.hosts = hosts;
    }

    public String getShardId() {
        return shardId;
    }

    public int getNumId() {
        return numId;
    }

    public ImmutableList<String> getHosts() {
        return hosts;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ShardInfo that = (ShardInfo) o;

        if (numId != that.numId) return false;
        if (!shardId.equals(that.shardId)) return false;
        return hosts.equals(that.hosts);
    }

    @Override
    public int hashCode() {
        int result = shardId.hashCode();
        result = 31 * result + numId;
        result = 31 * result + hosts.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ShardCreationResult{shardId='" + shardId
            + "', numId=" + Integer.toUnsignedLong(numId)
            + ", hosts=" + hosts + '}';
    }
}
