package ru.yandex.solomon.dataproxy.client;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monitoring.dataproxy.FindRequest;
import ru.yandex.monitoring.dataproxy.FindResponse;
import ru.yandex.monitoring.dataproxy.LabelKeysRequest;
import ru.yandex.monitoring.dataproxy.LabelKeysResponse;
import ru.yandex.monitoring.dataproxy.LabelValuesRequest;
import ru.yandex.monitoring.dataproxy.LabelValuesResponse;
import ru.yandex.monitoring.dataproxy.MetricNamesRequest;
import ru.yandex.monitoring.dataproxy.MetricNamesResponse;
import ru.yandex.monitoring.dataproxy.ReadManyRequest;
import ru.yandex.monitoring.dataproxy.ReadManyResponse;
import ru.yandex.monitoring.dataproxy.ReadOneRequest;
import ru.yandex.monitoring.dataproxy.ReadOneResponse;
import ru.yandex.monitoring.dataproxy.ResolveManyRequest;
import ru.yandex.monitoring.dataproxy.ResolveManyResponse;
import ru.yandex.monitoring.dataproxy.ResolveOneRequest;
import ru.yandex.monitoring.dataproxy.ResolveOneResponse;
import ru.yandex.monitoring.dataproxy.UniqueLabelsRequest;
import ru.yandex.monitoring.dataproxy.UniqueLabelsResponse;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public interface DataProxyClient extends AutoCloseable {
    /**
     * Returns metrics found by selectors.
     */
    CompletableFuture<FindResponse> find(FindRequest request, long deadlineMillis);

    /**
     * Returns metadata for single metric.
     */
    CompletableFuture<ResolveOneResponse> resolveOne(ResolveOneRequest request, long deadlineMillis);

    /**
     * Returns metadata for multiply metrics.
     */
    CompletableFuture<ResolveManyResponse> resolveMany(ResolveManyRequest request, long deadlineMillis);

    /**
     * Returns metadata for multiple metrics.
     * Order of returned metrics might not match order of metric keys in request.
     */
    CompletableFuture<MetricNamesResponse> metricNames(MetricNamesRequest request, long deadlineMillis);

    /**
     * Returns all possible label keys for metrics found by selectors.
     *  List of label keys consist unique sorted items.
     */
    CompletableFuture<LabelKeysResponse> labelKeys(LabelKeysRequest request, long deadlineMillis);

    /**
     * Returns possible values for metric labels found by selectors.
     */
    CompletableFuture<LabelValuesResponse> labelValues(LabelValuesRequest request, long deadlineMillis);

    /**
     * Returns all unique labels (key and value tuples) for metrics found by selectors.
     */
    CompletableFuture<UniqueLabelsResponse> uniqueLabels(UniqueLabelsRequest request, long deadlineMillis);

    /**
     * Returns timeseries data of single metric found by name and labels.
     */
    CompletableFuture<ReadOneResponse> readOne(ReadOneRequest request, long deadlineMillis);

    /**
     * Returns several timeseries of metrics found by selectors or fully qualified metrics keys.
     */
    CompletableFuture<ReadManyResponse> readMany(ReadManyRequest request, long deadlineMillis);

    @Override
    void close();
}
