package ru.yandex.solomon.dataproxy.client;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.net.HostAndPort;

import ru.yandex.discovery.DiscoveryServices;
import ru.yandex.grpc.conf.ClientOptionsFactory;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.config.protobuf.dataproxy.client.DataProxyClientConfig;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.util.host.DnsResolver;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class DataProxyClientFactory {

    private final ThreadPoolProvider threadPoolProvider;
    private final MetricRegistry registry;
    private final ClientOptionsFactory clientOptionsFactory;

    public DataProxyClientFactory(
            ThreadPoolProvider threadPoolProvider,
            MetricRegistry registry,
            ClientOptionsFactory clientOptionsFactory) {
        this.threadPoolProvider = threadPoolProvider;
        this.registry = registry;
        this.clientOptionsFactory = clientOptionsFactory;
    }

    public DataProxyClient createClient(String clientId, DataProxyClientConfig config) {
        List<HostAndPort> addresses = DiscoveryServices.resolve(config.getGrpcConfig().getAddressesList());
        if (addresses.isEmpty()) {
            throw new RuntimeException("no addresses found for DataProxy client");
        }
        var opts = clientOptionsFactory.newBuilder(
                "DataProxyClientConfig",
                config.getGrpcConfig())
            .setClientId(clientId)
            .setMetricRegistry(registry)
            .build();

        DnsResolver resolver = new NettyDnsResolver(threadPoolProvider.getIOExecutor());

        return new GrpcDataProxyClient(addresses, opts, resolver);
    }
}
