package ru.yandex.solomon.dataproxy.client;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.monlib.metrics.labels.Label;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.labels.LabelsBuilder;
import ru.yandex.solomon.util.protobuf.StringPool;

/**
 * @author Sergey Polovko
 */
public final class LabelsConverter {
    private LabelsConverter() {}

    public static List<String> toStringArray(Labels labels) {
        if (labels.isEmpty()) {
            return List.of();
        }

        int size = labels.size();
        var array = new ArrayList<String>(size * 2);
        for (int i = 0; i < size; i++) {
            Label label = labels.at(i);
            array.add(label.getKey());
            array.add(label.getValue());
        }
        return array;
    }

    public static List<Integer> toIntArray(StringPool.Builder builder, Labels labels) {
        if (labels.isEmpty()) {
            return List.of();
        }

        int size = labels.size();
        var array = new ArrayList<Integer>(size * 2);
        for (int i = 0; i < size; i++) {
            Label label = labels.at(i);
            array.add(builder.put(label.getKey()));
            array.add(builder.put(label.getValue()));
        }
        return array;
    }

    public static Labels fromStringArray(LabelsBuilder builder, List<String> array) {
        if (array.isEmpty()) {
            return Labels.empty();
        }

        builder.clear();
        for (int i = 0; i < array.size(); ) {
            String key = array.get(i++);
            String value = array.get(i++);
            builder.add(key, value);
        }
        return builder.build();
    }

    public static Labels fromIntArray(StringPool strings, LabelsBuilder builder, List<Integer> array) {
        if (array.isEmpty()) {
            return Labels.empty();
        }

        builder.clear();
        for (int i = 0; i < array.size();) {
            String key = strings.get(array.get(i++));
            String value = strings.get(array.get(i++));
            builder.add(key, value);
        }
        return builder.build();
    }
}
