package ru.yandex.discovery;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

import com.google.common.net.HostAndPort;

import ru.yandex.solomon.util.SolomonEnv;

/**
 * @author alexlovkov
 */
public interface DiscoveryService {

    static DiscoveryService async() {
        return AsyncDiscoveryService.Holder.INSTANCE;
    }

    static DiscoveryService async(SolomonEnv env, Executor executor) {
        return new AsyncDiscoveryService(env, executor);
    }

    CompletableFuture<List<HostAndPort>> resolve(List<String> hosts);

}
