package ru.yandex.discovery;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;

import com.google.common.net.HostAndPort;

/**
 * @author Vladimir Gordiychuk
 */
public class FilterDiscoveryService implements DiscoveryService {
    private final DiscoveryService target;
    private final Predicate<HostAndPort> predicate;

    public FilterDiscoveryService(DiscoveryService target, Predicate<HostAndPort> predicate) {
        this.target = target;
        this.predicate = predicate;
    }

    @Override
    public CompletableFuture<List<HostAndPort>> resolve(List<String> hosts) {
        return target.resolve(hosts)
                .thenApply(hostAndPorts -> hostAndPorts.stream()
                        .filter(predicate)
                        .collect(Collectors.toList()));
    }
}
