package ru.yandex.discovery.cluster;

import java.util.List;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.discovery.DiscoveryService;
import ru.yandex.solomon.config.protobuf.TClusterConfig;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;

/**
 * @author alexlovkov
 */
@Configuration
public class ClusterMapperContext {
    @Bean
    public ClusterMapperImpl clusterMapper(@Qualifier("ClustersConfig") List clusters, ThreadPoolProvider threads) {
        var executor = threads.getExecutorService("CpuLowPriority", "");
        var timer = threads.getSchedulerExecutorService();
        var discovery = DiscoveryService.async();
        return new ClusterMapperImpl((List<TClusterConfig>) clusters, discovery, executor, timer);
    }
}
