package ru.yandex.discovery.cluster;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

import javax.annotation.Nullable;

import ru.yandex.misc.lang.StringUtils;

/**
 * @author Vladimir Gordiychuk
 */
public class ClusterMapperStub implements ClusterMapper {
    public Map<String, String> clusterByHost = new ConcurrentHashMap<>();

    @Nullable
    @Override
    public String byFqdnOrNull(String fqdn) {
        return clusterByHost.get(fqdn.toLowerCase());
    }

    @Nullable
    @Override
    public String byParamOrNull(String param) {
        if (StringUtils.isEmpty(param)) {
            return null;
        }

        String lowerParam = param.toLowerCase();
        return clusterByHost.containsKey(lowerParam) ? lowerParam : null;
    }

    @Override
    public Set<String> knownClusterIds() {
        return new HashSet<>(clusterByHost.values());
    }

    @Override
    public String byFqdnOrThrow(String fqdn) {
        String cluster = byFqdnOrNull(fqdn);
        if (cluster == null) {
            throw new IllegalArgumentException("cannot determine cluster by fqdn: " + fqdn);
        }
        return cluster;
    }
}
