package ru.yandex.discovery.solomon;

import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;


/**
 * @author alexlovkov
 **/
@JsonIgnoreProperties(ignoreUnknown = true)
public class SolomonDiscoveryResponse {

    private final String envType;
    private final List<Host> hosts;
    private final Port port;
    private final String serviceName;

    @JsonCreator
    public SolomonDiscoveryResponse(
        @JsonProperty(value = "envType", required = true) String envType,
        @JsonProperty(value = "hosts", required = true) List<Host> hosts,
        @JsonProperty(value = "ports", required = true) Port port,
        @JsonProperty(value = "serviceName", required = true) String serviceName)
    {
        this.envType = envType;
        this.hosts = hosts;
        this.port = port;
        this.serviceName = serviceName;
    }

    @Override
    public String toString() {
        return "SolomonDiscoveryResponse{" +
            "envType='" + envType + '\'' +
            ", hosts=" + hosts +
            ", ports=" + port +
            ", serviceName='" + serviceName + '\'' +
            '}';
    }

    public String getEnvType() {
        return envType;
    }

    public List<Host> getHosts() {
        return hosts;
    }

    public Port getPort() {
        return port;
    }

    public String getServiceName() {
        return serviceName;
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Host {

        private final String address;
        private final String cluster;
        private final String fqdn;

        public Host(
            @JsonProperty(value = "address", required = true) String address,
            @JsonProperty(value = "cluster", required = true) String cluster,
            @JsonProperty(value = "fqdn", required = true) String fqdn)
        {
            this.address = address;
            this.cluster = cluster;
            this.fqdn = fqdn;
        }

        public String getAddress() {
            return address;
        }

        public String getCluster() {
            return cluster;
        }

        public String getFqdn() {
            return fqdn;
        }

        @Override
        public String toString() {
            return "Host{" +
                "address='" + address + '\'' +
                ", cluster='" + cluster + '\'' +
                ", fqdn='" + fqdn + '\'' +
                '}';
        }
    }

    public static class Port {
        private final int num;

        @JsonCreator
        public Port(Map<String, Integer> nameToPort) {
            this.num = nameToPort.size() > 1 ? -1 :
                    nameToPort.values().stream().findFirst().orElseThrow(IllegalArgumentException::new);
        }

        public int getNum() {
            return num;
        }

        @Override
        public String toString() {
            return "Port{" +
                    "port=" + num +
                    '}';
        }
    }

}
