package ru.yandex.discovery;

import java.util.Arrays;
import java.util.List;

import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.MoreExecutors;
import org.junit.Assert;
import org.junit.Test;

import ru.yandex.devtools.test.annotations.YaIgnore;
import ru.yandex.solomon.util.SolomonEnv;


/**
 * @author alexlovkov
 */
@YaIgnore
public class AsyncDiscoveryServiceTest {

    @Test
    public void resolveConductorHostAndPort() {
        List<String> addresses = Arrays.asList(
            "solomon-stp-man-10.search.yandex.net:666",
            "conductor_group://solomon_stockpile_man:666",
            "localhost:666",
            "localhost2:666");
        List<HostAndPort> resolvedHosts = DiscoveryServices.resolve(addresses);
        Assert.assertEquals(34, resolvedHosts.size());
        for (HostAndPort address : resolvedHosts) {
            Assert.assertEquals(666, address.getPort());
        }
    }

    @Test
    public void resolveSolomonHostAndPort() {
        List<String> addresses = Arrays.asList(
            "solomon://solomon.yandex.net/discovery/TESTING/metabase:grpc",
            "solomon://solomon.yandex.net/discovery/TESTING/stockpile:grpc");

        List<HostAndPort> resolvedHosts = DiscoveryService.async(SolomonEnv.TESTING, MoreExecutors.directExecutor())
            .resolve(addresses)
            .join();

        Assert.assertEquals(32, resolvedHosts.size());
        for (HostAndPort address : resolvedHosts) {
            int port = address.getPort();
            Assert.assertTrue(port == 5710 || port == 5700);
        }
    }
}
