package ru.yandex.discovery.solomon;

import java.io.IOException;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.Assert;
import org.junit.Test;


/**
 * @author alexlovkov
 **/
public class SolomonDiscoveryResponseTest {

    @Test
    public void deserializeTest() throws IOException {
        String json = """
                {
                    "envType": "PRESTABLE",
                    "fakeFiled": "123",
                    "hosts": [
                        {
                            "address": "2a02:6b8:b000:6600:feaa:14ff:fea7:6668",
                            "cluster": "man",
                            "fake1": "fakeValue",
                            "fqdn": "solomon-pre-man-21.search.yandex.net"
                        }
                    ],
                    "ports": {
                        "grpc": 5700
                    },
                    "serviceName": "stockpile"
                }""";

        ObjectMapper objectMapper = new ObjectMapper();
        SolomonDiscoveryResponse res =
            objectMapper.readValue(json, SolomonDiscoveryResponse.class);

        Assert.assertEquals("PRESTABLE", res.getEnvType());
        Assert.assertEquals("man", res.getHosts().get(0).getCluster());
        Assert.assertEquals(5700, res.getPort().getNum());
        Assert.assertEquals("stockpile", res.getServiceName());
    }
}
