package ru.yandex.discovery.solomon;

import java.util.List;

import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.MoreExecutors;
import org.junit.Assert;
import org.junit.Test;

import ru.yandex.devtools.test.annotations.YaIgnore;
import ru.yandex.solomon.util.SolomonEnv;

import static org.junit.Assert.assertEquals;


/**
 * @author alexlovkov
 **/
@YaIgnore
public class SolomonResolverServiceTest {
    @Test
    public void resolve() {
        var solomonResolverService = new SolomonResolverService(SolomonEnv.TESTING, MoreExecutors.directExecutor());
        String solomonAddress = "solomon://solomon.yandex.net/discovery/TESTING/metabase:grpc";
        List<HostAndPort> hosts = solomonResolverService.resolve(solomonAddress).join();
        assertEquals(16, hosts.size());
        for (HostAndPort hostAndPort : hosts) {
            Assert.assertTrue(hostAndPort.getHost().contains("solomon-test"));
            assertEquals(5710, hostAndPort.getPort());
        }
    }
}
