package ru.yandex.solomon.locks;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public interface DistributedLock {
    /**
     * @return true if current application held distributed lock
     */
    boolean isLockedByMe();

    /**
     * @return details about current lock, empty optional indicate about absent
     * lock owner
     */
    Optional<LockDetail> lockDetail();

    CompletableFuture<Optional<LockDetail>> getLockDetail(long latestVisibleSeqNo);

    /**
     * @param subscription callback function that will be call after success acquire distributed
     *                     lock and when particular acquire will be unlocked
     * @param leaseTime    the maximum time after that lock will be released
     * @param unit         the time unit of the {@code leaseTime} argument
     */
    void acquireLock(LockSubscriber subscription, long leaseTime, TimeUnit unit);

    /**
     * @return release lock only if current application acquired it
     */
    CompletableFuture<Boolean> unlock();
}
