package ru.yandex.solomon.locks;

import java.util.concurrent.TimeUnit;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
class DistributedLockMetrics {
    private final MetricRegistry registry;
    private volatile long lockedWhenNanoTime = 0;

    DistributedLockMetrics(String lockAlias, MetricRegistry registry) {
        this(registry.subRegistry("lock", lockAlias));
    }

    private DistributedLockMetrics(MetricRegistry registry) {
        this.registry = registry;
        // TODO: it should be lazy counter because parameter grow until lock expire (gordiychuk@)
        registry.lazyGaugeInt64("distributed.lock.lockedTimeMillis", Labels.of(), () -> {
            long nano = lockedWhenNanoTime;
            if (nano == 0) {
                return 0;
            } else {
                return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - nano);
            }
        });
    }

    void lockAcquired() {
        this.lockedWhenNanoTime = System.nanoTime();
    }

    void releaseLock(UnlockReason reason) {
        this.registry.counter("distributed.lock.release", Labels.of("reason", reason.name())).inc();
        this.lockedWhenNanoTime = 0;
    }
}
