package ru.yandex.solomon.locks;

import java.time.Instant;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public record LockDetail(String id, String owner, long seqNo, Instant expiredAt) {
    public boolean isExpired(Instant now) {
        return !now.isBefore(expiredAt);
    }

    public LockDetail expiredAt(Instant expiredAt) {
        return new LockDetail(id, owner, seqNo, expiredAt);
    }
}
