package ru.yandex.solomon.locks;

import java.time.Clock;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillCloseWhenClosed;

import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.locks.dao.LocksDao;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class LockServiceImpl implements LockService {
    private final String me;
    private final LocksDao dao;
    private final Clock clock;
    @WillCloseWhenClosed
    private final ScheduledExecutorService executorService;
    private final MetricRegistry registry;
    private final ConcurrentMap<String, DistributedLock> locks = new ConcurrentHashMap<>();

    public LockServiceImpl(
        String me,
        LocksDao dao,
        Clock clock,
        ScheduledExecutorService executorService,
        MetricRegistry registry)
    {
        this.me = me;
        this.dao = dao;
        this.clock = clock;
        this.executorService = executorService;
        this.registry = registry;
    }

    @Override
    public DistributedLock distributedLock(String lockId, String lockAlias) {
        return locks.computeIfAbsent(
            lockId,
            name -> new DistributedLockImpl(lockId, lockAlias, me, dao, clock, executorService, registry));
    }
}
