package ru.yandex.solomon.locks;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public interface LockSubscriber {
    /**
     * @return true if current lock subscription not actual anymore
     */
    boolean isCanceled();

    /**
     * Will be call only once as only distributed lock will be acquired
     */
    void onLock(long seqNo);

    /**
     * Will be call only once as only ownership of distributed lock will be lost,
     * by any reason(expire, unlock, force unlock, connection lost)
     */
    void onUnlock(UnlockReason reason);
}
