package ru.yandex.solomon.locks.dao;

import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.locks.LockDetail;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public interface LocksDao {
    /**
     * Acquire lock only if previous lock absent or already expired. Always return actual lock state
     * as a result event if acquire failed.
     */
    CompletableFuture<LockDetail> acquireLock(String lockId, String owner, Instant expiredAt);

    CompletableFuture<Optional<LockDetail>> readLock(String lockId);

    CompletableFuture<Boolean> extendLockTime(String lockId, String owner, Instant expiredAt);

    CompletableFuture<Boolean> releaseLock(String lockId, String owner);

    CompletableFuture<List<LockDetail>> listLocks();
}
