package ru.yandex.solomon.locks.dao.ydb;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.ydb.table.result.ResultSetReader;

import ru.yandex.solomon.locks.LockDetail;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
class ColumnReader {
    private final int idIdx;
    private final int ownerIdx;
    private final int seqNoIdx;
    private final int expireAtIdx;

    public ColumnReader(ResultSetReader r) {
        this.idIdx = r.getColumnIndex("id");
        this.ownerIdx = r.getColumnIndex("owner");
        this.seqNoIdx = r.getColumnIndex("seq_no");
        this.expireAtIdx = r.getColumnIndex("expire_at");
    }

    public LockDetail read(ResultSetReader r) {
        var id = r.getColumn(idIdx).getUtf8();
        var owner = r.getColumn(ownerIdx).getUtf8();
        long seqNo = r.getColumn(seqNoIdx).getInt64();
        var expiredAt = r.getColumn(expireAtIdx).getTimestamp();
        return new LockDetail(id, owner, seqNo, expiredAt);
    }
}
