package ru.yandex.solomon.locks.dao.ydb;

import java.util.ArrayList;
import java.util.function.Consumer;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.ydb.table.result.ResultSetReader;

import ru.yandex.solomon.locks.LockDetail;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class RecordReader implements Consumer<ResultSetReader> {
    final ArrayList<LockDetail> records = new ArrayList<>();
    @Nullable
    LockDetail last;

    @Override
    public void accept(ResultSetReader resultSet) {
        int rowCount = resultSet.getRowCount();
        if (rowCount == 0) {
            return;
        }

        records.ensureCapacity(records.size() + rowCount);

        var columns = new ColumnReader(resultSet);
        while (resultSet.next()) {
            last = columns.read(resultSet);
            records.add(last);
        }
    }
}
