package ru.yandex.solomon.locks.dao.ydb;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.io.Resources;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class YdbLocksQuery {
    public final String acquire;
    public final String read;
    public final String extend;
    public final String release;
    public final String list;

    public YdbLocksQuery(String tablePath) {
        this.acquire = YdbLocksQuery.loadQuery("query/acquireLock.sql", tablePath);
        this.read = YdbLocksQuery.loadQuery("query/readLock.sql", tablePath);
        this.extend = YdbLocksQuery.loadQuery("query/extendLock.sql", tablePath);
        this.release = YdbLocksQuery.loadQuery("query/releaseLock.sql", tablePath);
        this.list = YdbLocksQuery.loadQuery("query/listLock.sql", tablePath);
    }

    private static String loadQuery(String name, String table) {
        try {
            var resource = Objects.requireNonNull(YdbLocksQuery.class.getResource(name));
            String template = Resources.toString(resource, StandardCharsets.UTF_8);
            return template.replace("$table", "`" + table + "`");
        } catch (IOException e) {
            throw new UncheckedIOException("cannot load query: " + name, e);
        }
    }
}
