--!syntax_v1
DECLARE $id as Utf8;
DECLARE $owner as Utf8;
DECLARE $expiration_time as Int64;
DECLARE $expire_at as Timestamp;
DECLARE $now as Timestamp;
DECLARE $seq_no as Int64;

$source = (
  SELECT
    AsStruct(
      id as id,
      owner as owner,
      seq_no as seq_no,
      expiration_time as expiration_time,
      expire_at as expire_at,
      0 as priority
    )
  FROM $table
  WHERE id = $id AND expire_at > $now
);

$result = (
  SELECT
    $id as id,
    COALESCE($source.owner, $owner) as owner,
    COALESCE($source.seq_no, $seq_no) as seq_no,
    COALESCE($source.expiration_time, $expiration_time) as expiration_time,
    COALESCE($source.expire_at, $expire_at) as expire_at,
    COALESCE($source.priority, 1) as priority
);

SELECT * FROM $result;

REPLACE INTO $table(id, owner, seq_no, expiration_time, expire_at)
SELECT t.id, t.owner, t.seq_no, t.expiration_time, t.expire_at FROM $result as t
WHERE t.priority > 0;
