package ru.yandex.solomon.locks.dao;

import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;

import ru.yandex.solomon.kikimr.LocalKikimr;
import ru.yandex.solomon.kikimr.YdbHelper;
import ru.yandex.solomon.locks.dao.ydb.YdbLocksDao;

/**
 * @author Sergey Polovko
 */
public class YdbLocksDaoTest extends LocksDaoTest {

    @ClassRule
    public static LocalKikimr kikimr = new LocalKikimr();
    private YdbHelper ydb;
    private YdbLocksDao dao;

    @Before
    public void before() {
        ydb = new YdbHelper(kikimr, YdbLocksDaoTest.class.getSimpleName());
        dao = new YdbLocksDao(ydb.getTableClient(), LocksDaoTest.CLOCK, ydb.getRootPath());
        dao.createSchema().join();
    }

    @After
    public void after() {
        ydb.close();
    }

    @Override
    public LocksDao getDao() {
        return dao;
    }
}
