package ru.yandex.solomon.scheduler;

import java.util.concurrent.CompletableFuture;

import com.google.protobuf.Message;

/**
 * @author Vladimir Gordiychuk
 */
public interface ExecutionContext {
    Task task();

    /**
     * @return {@code true} if task execution completed or interrupted, all evaluation at handler should be stopped
     */
    boolean isDone();

    /**
     * Complete task evaluation with success status
     */
    <T extends Message> CompletableFuture<?> complete(T result);

    /**
     * Complete task evaluation with error status
     */
    CompletableFuture<?> fail(Throwable e);

    /**
     * Stop current evaluation, and schedule repeat run at specified time
     */
    <T extends Message> CompletableFuture<?> reschedule(long executeAt, T progress);

    /**
     * Persist current progress for task
     */
    <T extends Message> CompletableFuture<?> progress(T progress);

    /**
     * Cancel current evaluation without any result, task will be rescheduled maybe on another node
     */
    CompletableFuture<?> cancel();
}
