package ru.yandex.solomon.scheduler;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * @author Vladimir Gordiychuk
 */
public class PermitLimiter {
    private final AtomicInteger permits;

    public PermitLimiter(int maxInflight) {
        this.permits = new AtomicInteger(maxInflight);

    }

    public Permit acquire() {
        int count;
        do {
            count = permits.get();
            if (count <= 0) {
                return null;
            }
        } while (!permits.compareAndSet(count, count - 1));
        return new PermitImpl();
    }

    private class PermitImpl implements Permit {
        private final AtomicBoolean done = new AtomicBoolean();

        public PermitImpl() {
        }

        @Override
        public void cancel() {
            release();
        }

        @Override
        public void release() {
            if (done.compareAndSet(false, true)) {
                permits.incrementAndGet();
            }
        }
    }
}
