package ru.yandex.solomon.scheduler;

import com.google.protobuf.Any;

/**
 * @author Stanislav Kashirin
 */
public interface ProgressOperator {

    Result apply(Any progress);

    sealed interface Result { }

    record Ok(Any newProgress) implements Result { }
    record Stop() implements Result { }
    record Fail(Throwable cause) implements Result { }

    static ProgressOperator identity() {
        return Ok::new;
    }
}
