package ru.yandex.solomon.scheduler;

import java.time.Clock;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

import ru.yandex.solomon.locks.dao.LocksDao;
import ru.yandex.solomon.scheduler.dao.SchedulerDao;

/**
 * @author Vladimir Gordiychuk
 */
public class TaskDeps {
    public final String node;
    public final TaskExecutor taskExecutor;
    public final SchedulerDao dao;
    public final LocksDao locksDao;
    public final Clock clock;
    public final Executor executor;
    public final ScheduledExecutorService timer;

    public TaskDeps(
            String node,
            TaskExecutor taskExecutor,
            SchedulerDao dao,
            LocksDao locksDao,
            Clock clock,
            Executor executor,
            ScheduledExecutorService timer)
    {
        this.node = node;
        this.taskExecutor = taskExecutor;
        this.dao = dao;
        this.locksDao = locksDao;
        this.clock = clock;
        this.executor = executor;
        this.timer = timer;
    }
}
