package ru.yandex.solomon.scheduler;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;

import javax.annotation.Nullable;

import com.google.protobuf.Any;

/**
 * @author Vladimir Gordiychuk
 */
public class TaskExecutorImpl implements TaskExecutor {
    private final Executor executor;
    private final Map<String, TaskHandler> handlerByType;

    public TaskExecutorImpl(Executor executor, List<TaskHandler> handlers) {
        this.executor = executor;
        this.handlerByType = handlers.stream().collect(Collectors.toMap(TaskHandler::type, Function.identity()));
    }

    @Nullable
    @Override
    public Permit acquire(String id, String type, Any params) {
        var handler = handlerByType.get(type);
        if (handler == null) {
            return null;
        }

        return handler.acquire(id, params);
    }

    @Override
    public void execute(ExecutionContext context) {
        var handler = Objects.requireNonNull(handlerByType.get(context.task().type()), "not defined task handler");
        executor.execute(() -> {
            try {
                handler.execute(context);
            } catch (Throwable e) {
                context.fail(e);
            }
        });
    }
}
