package ru.yandex.solomon.scheduler;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Any;
import com.google.protobuf.Descriptors.Descriptor;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public interface TaskHandler {

    String type();

    @Nullable
    Permit acquire(String id, Any params);

    void execute(ExecutionContext context);

    List<Descriptor> descriptors();
}
