package ru.yandex.solomon.scheduler;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import static ru.yandex.solomon.scheduler.ProgressOperator.identity;

/**
 * @author Vladimir Gordiychuk
 */
public interface TaskScheduler {
    CompletableFuture<Optional<Task>> getTask(String taskId);

    CompletableFuture<Void> schedule(Task task);

    default CompletableFuture<Boolean> reschedule(String taskId, long executeAt) {
        return reschedule(taskId, executeAt, identity());
    }

    /**
     * Updates progress of a (possibly running) non-completed task and reschedules it to the given time.
     * <p>
     * Could be used for non-preemptive interruption: in that case a task is expected to be cooperative.
     */
    CompletableFuture<Boolean> reschedule(String taskId, long executeAt, ProgressOperator progressOperator);
}
