package ru.yandex.solomon.scheduler.dao;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

import com.google.protobuf.Any;
import io.grpc.Status;

import ru.yandex.solomon.scheduler.ScheduledTask;
import ru.yandex.solomon.scheduler.Task;
import ru.yandex.solomon.scheduler.Task.State;

/**
 * @author Vladimir Gordiychuk
 */
public interface SchedulerDao {

    CompletableFuture<Void> createSchema();

    /**
     * Check task id unique, add task to scheduled task queue
     */
    CompletableFuture<Boolean> add(Task task);

    /**
     * Get scheduled or completed task by id
     */
    CompletableFuture<Optional<Task>> get(String taskId);

    /**
     * Update task state
     * @return {@code false} if already completed or started by other
     */
    CompletableFuture<Boolean> changeState(String taskId, State state, long seqNo);

    /**
     * Remove scheduled, complete task
     */
    CompletableFuture<Boolean> complete(String taskId, Any result, long seqNo);

    /**
     * Remove scheduled, complete with error
     */
    CompletableFuture<Boolean> failed(String taskId, Status status, long seqNo);

    /**
     * Change state to scheduled, update time for run
     */
    CompletableFuture<Boolean> reschedule(String taskId, long executeAt, Any progress, long seqNo);

    /**
     * Conditionally (by comparing versions) updates time for run & progress, bumping current seqNo
     *
     * Does not affect current state (rely on cooperation for rescheduling of running tasks)
     */
    CompletableFuture<Boolean> rescheduleExternally(
        String taskId,
        long executeAt,
        Any progress,
        int expectedVersion);

    CompletableFuture<Boolean> progress(String taskId, Any progress, long seqNo);

    CompletableFuture<Void> list(Consumer<Task> consumer);

    CompletableFuture<List<ScheduledTask>> listScheduled(long now, int limit);
}
