package ru.yandex.solomon.scheduler.dao.ydb;

/**
 * @author Vladimir Gordiychuk
 */
public class YdbSchedulerQuery {
    static final int SELECT_LIMIT = 1000;

    //language=SQL
    private static final String INSERT = """
            --!syntax_v1
            DECLARE $hash AS Uint32;
            DECLARE $id AS Utf8;
            DECLARE $type AS Utf8;
            DECLARE $params AS String;
            DECLARE $execute_at AS Timestamp;
            DECLARE $version AS Uint32;

            INSERT INTO `TASKS_TABLE`(hash, id, type, params, execute_at, version)
            VALUES ($hash, $id, $type, $params, $execute_at, $version);

            INSERT INTO `SCHEDULED_TABLE`(execute_at, id, type, params)
            VALUES ($execute_at, $id, $type, $params);
            """;

    //language=SQL
    private static final String SELECT_ONE = """
            --!syntax_v1
            DECLARE $hash AS Uint32;
            DECLARE $id AS Utf8;

            SELECT * FROM `TASKS_TABLE` WHERE hash = $hash AND id = $id;
            """;

    //language=SQL
    private static final String CHANGE_STATE = """
            --!syntax_v1
            DECLARE $hash AS Uint32;
            DECLARE $id AS Utf8;
            DECLARE $seq_no AS Uint64;
            DECLARE $state AS Uint8;

            $to_update = (
                SELECT hash,
                       id,
                       $state as state,
                       $seq_no as seq_no
                FROM `TASKS_TABLE`
                WHERE hash = $hash AND id = $id AND COALESCE(seq_no, 0) <= $seq_no AND COALESCE(state, 0) IN (0, 1)
            );

            SELECT true FROM $to_update;

            UPDATE `TASKS_TABLE` ON
            SELECT hash, id, state, seq_no FROM $to_update;
            """;

    //language=SQL
    private static final String COMPLETE = """
            --!syntax_v1
            DECLARE $hash AS Uint32;
            DECLARE $id AS Utf8;
            DECLARE $seq_no AS Uint64;
            DECLARE $result AS String;
            DECLARE $status_code AS Int32;
            DECLARE $status_description AS Utf8;
            DECLARE $now AS Timestamp;

            $to_update = (
                SELECT hash,
                       id,
                       execute_at,
                       cast(2 As Uint8) as state,
                       $seq_no as seq_no,
                       $result as result,
                       $status_code as status_code,
                       $status_description as status_description,
                       $now as completed_at
                FROM `TASKS_TABLE`
                WHERE hash = $hash AND id = $id AND COALESCE(seq_no, 0) <= $seq_no AND COALESCE(state, 0) IN (0, 1)
            );

            SELECT true FROM $to_update;

            DELETE FROM `SCHEDULED_TABLE` ON
            SELECT execute_at, id FROM $to_update;

            UPDATE `TASKS_TABLE` ON
            SELECT hash, id, seq_no, state, result, status_code, status_description, completed_at FROM $to_update;
            """;

    //language=SQL
    private static final String RESCHEDULE = """
            --!syntax_v1
            DECLARE $hash AS Uint32;
            DECLARE $id AS Utf8;
            DECLARE $seq_no AS Uint64;
            DECLARE $progress AS String;
            DECLARE $execute_at AS Timestamp;

            $to_update = (
                SELECT hash,
                       id,
                       type,
                       params,
                       $seq_no as seq_no,
                       $execute_at as execute_at,
                       execute_at as execute_at_prev,
                       $progress as progress,
                       COALESCE(version, 0) as version_prev
                FROM `TASKS_TABLE`
                WHERE hash = $hash AND id = $id AND COALESCE(seq_no, 0) <= $seq_no AND COALESCE(state, 0) IN (0, 1)
            );

            SELECT true FROM $to_update;

            DELETE FROM `SCHEDULED_TABLE` ON
            SELECT execute_at_prev as execute_at, id FROM $to_update;

            UPSERT INTO `SCHEDULED_TABLE`
            SELECT execute_at, id, type, params FROM $to_update;

            UPDATE `TASKS_TABLE` ON
            SELECT hash,
                   id,
                   seq_no,
                   execute_at,
                   cast(0 As Uint8) as state,
                   progress,
                   cast(version_prev + 1 As Uint32) as version
            FROM $to_update;
            """;

    //language=SQL
    private static final String RESCHEDULE_EXTERNALLY = """
            --!syntax_v1
            DECLARE $hash AS Uint32;
            DECLARE $id AS Utf8;
            DECLARE $progress AS String;
            DECLARE $execute_at AS Timestamp;
            DECLARE $version AS Uint32;

            $to_update = (
                SELECT hash,
                       id,
                       type,
                       params,
                       seq_no as seq_no_prev,
                       $execute_at as execute_at,
                       execute_at as execute_at_prev,
                       $progress as progress,
                       $version as version_prev
                FROM `TASKS_TABLE`
                WHERE hash = $hash AND id = $id AND COALESCE(state, 0) IN (0, 1) AND COALESCE(version, 0) = $version
            );

            SELECT true FROM $to_update;

            DELETE FROM `SCHEDULED_TABLE` ON
            SELECT execute_at_prev as execute_at, id FROM $to_update;

            UPSERT INTO `SCHEDULED_TABLE`
            SELECT execute_at, id, type, params FROM $to_update;

            UPDATE `TASKS_TABLE` ON
            SELECT hash,
                   id,
                   (seq_no_prev + 1) as seq_no,
                   execute_at,
                   progress,
                   cast(version_prev + 1 As Uint32) as version
            FROM $to_update;
            """;

    //language=SQL
    private static final String PROGRESS = """
            --!syntax_v1
            DECLARE $hash AS Uint32;
            DECLARE $id AS Utf8;
            DECLARE $seq_no AS Uint64;
            DECLARE $progress AS String;

            $to_update = (
                SELECT hash,
                       id,
                       $seq_no as seq_no,
                       $progress as progress,
                       COALESCE(version, 0) as version_prev
                FROM `TASKS_TABLE`
                WHERE hash = $hash AND id = $id AND COALESCE(seq_no, 0) <= $seq_no AND COALESCE(state, 0) = 1
            );

            SELECT true FROM $to_update;

            UPDATE `TASKS_TABLE` ON
            SELECT hash, id, seq_no, progress, cast(version_prev + 1 As Uint32) as version FROM $to_update;
            """;

    //language=SQL
    private static final String LIST_SCHEDULED = """
            DECLARE $execute_at AS Timestamp;
            SELECT * FROM `SCHEDULED_TABLE`
            WHERE execute_at <= $execute_at
            LIMIT SELECT_LIMIT;
            """;

    final String root;
    final String tableTasks;
    final String tableScheduled;
    final String insert;
    final String selectOne;
    final String changeState;
    final String complete;
    final String reschedule;
    final String rescheduleExternally;
    final String progress;
    final String scheduled;

    public YdbSchedulerQuery(String root) {
        this.root = root;
        this.tableTasks = root + "/Tasks";
        this.tableScheduled = root + "/ScheduledTasks";
        this.selectOne = prepare(SELECT_ONE);
        this.insert = prepare(INSERT);
        this.changeState = prepare(CHANGE_STATE);
        this.complete = prepare(COMPLETE);
        this.reschedule = prepare(RESCHEDULE);
        this.rescheduleExternally = prepare(RESCHEDULE_EXTERNALLY);
        this.progress = prepare(PROGRESS);
        this.scheduled = prepare(LIST_SCHEDULED);
    }

    private String prepare(String query) {
        return query
                .replaceAll("TASKS_TABLE", tableTasks)
                .replaceAll("SCHEDULED_TABLE", tableScheduled)
                .replaceAll("SELECT_LIMIT", String.valueOf(SELECT_LIMIT));
    }
}
