package ru.yandex.solomon.scheduler.grpc;

import io.grpc.Status;
import io.grpc.stub.StreamObserver;

import ru.yandex.grpc.utils.InternalGrpcService;
import ru.yandex.solomon.scheduler.TaskScheduler;
import ru.yandex.solomon.scheduler.proto.GetTaskRequest;
import ru.yandex.solomon.scheduler.proto.Task;
import ru.yandex.solomon.scheduler.proto.TaskSchedulerServiceGrpc.TaskSchedulerServiceImplBase;

/**
 * @author Vladimir Gordiychuk
 */
public class GrpcSchedulerService extends TaskSchedulerServiceImplBase implements InternalGrpcService {
    private final TaskScheduler scheduler;

    public GrpcSchedulerService(TaskScheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public void getTask(GetTaskRequest request, StreamObserver<Task> observer) {
        scheduler.getTask(request.getId())
                .thenApply(optTask -> {
                    var task = optTask.orElseThrow(Status.NOT_FOUND::asRuntimeException);
                    return Proto.toProto(task);
                })
                .whenComplete((response, throwable) -> {
                    if (throwable != null) {
                        observer.onError(throwable);
                    } else {
                        observer.onNext(response);
                        observer.onCompleted();
                    }
                });
    }
}
