package ru.yandex.solomon.scheduler.grpc;

import com.google.common.base.Strings;
import io.grpc.Status;

import ru.yandex.solomon.scheduler.Task;
import ru.yandex.solomon.scheduler.Task.State;

/**
 * @author Vladimir Gordiychuk
 */
public class Proto {

    public static ru.yandex.solomon.scheduler.proto.Task toProto(Task task) {
        return ru.yandex.solomon.scheduler.proto.Task.newBuilder()
                .setId(task.id())
                .setType(task.type())
                .setParams(task.params())
                .setExecuteAt(task.executeAt())
                .setStateValue(task.state().number)
                .setStatus(Proto.toProto(task.status()))
                .setProgress(task.progress())
                .setResult(task.result())
                .setVersion(task.version())
                .build();
    }

    public static Task fromProto(ru.yandex.solomon.scheduler.proto.Task proto) {
        return Task.newBuilder()
                .setId(proto.getId())
                .setType(proto.getType())
                .setParams(proto.getParams())
                .setExecuteAt(proto.getExecuteAt())
                .setState(State.valueOf(proto.getStateValue()))
                .setStatus(fromProto(proto.getStatus()))
                .setProgress(proto.getProgress())
                .setResult(proto.getResult())
                .setVersion(proto.getVersion())
                .build();
    }

    public static com.google.rpc.Status toProto(Status status) {
        var builder = com.google.rpc.Status.newBuilder().setCode(status.getCode().value());
        if (status.getDescription() != null) {
            builder.setMessage(status.getDescription());
        }
        return builder.build();
    }

    public static Status fromProto(com.google.rpc.Status status) {
        var result = Status.fromCodeValue(status.getCode());
        if (Strings.isNullOrEmpty(status.getMessage())) {
            return result;
        }

        return result.withDescription(status.getMessage());
    }
}
