package ru.yandex.solomon.scheduler.www;

import java.time.Instant;

import com.google.common.base.Strings;
import com.google.protobuf.TextFormat;
import com.google.protobuf.TypeRegistry;

import ru.yandex.solomon.scheduler.Task;
import ru.yandex.solomon.staffOnly.www.ManagerPageTemplate;
import ru.yandex.solomon.util.time.DurationUtils;

import static ru.yandex.solomon.scheduler.Task.State;

/**
 * @author Vladimir Gordiychuk
 */
public class TaskPage extends ManagerPageTemplate {

    private final Task task;
    private final TypeRegistry registry;

    public TaskPage(Task task, TypeRegistry registry) {
        super("Task " + task.id());
        this.task = task;
        this.registry = registry;
    }

    @Override
    protected void content() {
        h1("Fields");
        tableTable(() -> {
            trThs("Property", "Value");

            tr(() -> {
                thText("Id");
                tdText(task.id());
            });

            tr(() -> {
                thText("Type");
                tdText(task.type());
            });

            tr(() -> {
                thText("Params");
                td(() -> {
                    preText(TextFormat.printer()
                            .usingTypeRegistry(registry)
                            .printToString(task.params()));
                });
            });

            tr(() -> {
                thText("ExecuteAt");
                td(() -> {
                    write(Instant.ofEpochMilli(task.executeAt()).toString());
                    write(" delay ");
                    write(DurationUtils.formatDurationMillisTruncated(task.executeAt() - System.currentTimeMillis()));
                });
            });

            tr(() -> {
                thText("State");
                tdText(task.state().name());
            });

            if (task.state().number > State.RUNNING.number) {
                tr(() -> {
                    thText("StatusCode");
                    tdText(task.status().getCode().name());
                });

                if (!Strings.isNullOrEmpty(task.status().getDescription())) {
                    tr(() -> {
                        thText("StatusDetails");
                        td(() -> {
                            preText(task.status().getDescription());
                        });
                    });
                }

                if (task.status().isOk()) {
                    tr(() -> {
                        thText("Result");
                        td(() -> {
                            preText(TextFormat.printer()
                                    .usingTypeRegistry(registry)
                                    .printToString(task.result()));
                        });
                    });
                }
            }

            tr(() -> {
                thText("Progress");
                td(() -> {
                    preText(TextFormat.printer()
                            .usingTypeRegistry(registry)
                            .printToString(task.progress()));
                });
            });

            tr(() -> {
                thText("Version");
                tdText(Integer.toString(task.version()));
            });
        });
    }
}
