package ru.yandex.solomon.scheduler;

import java.util.concurrent.ThreadLocalRandom;

import com.google.protobuf.Any;
import com.google.protobuf.Int64Value;
import io.grpc.Status;
import org.junit.Test;

import ru.yandex.solomon.scheduler.Task.State;

import static org.junit.Assert.assertEquals;

/**
 * @author Vladimir Gordiychuk
 */
public class TaskTest {

    @Test
    public void toBuilderAndBack() {
        Task expect = Task.newBuilder()
                .setId("test")
                .setExecuteAt(ThreadLocalRandom.current().nextLong())
                .setParams(Any.pack(Int64Value.of(ThreadLocalRandom.current().nextLong())))
                .setResult(Any.pack(Int64Value.of(ThreadLocalRandom.current().nextLong())))
                .setProgress(Any.pack(Int64Value.of(ThreadLocalRandom.current().nextLong())))
                .setType("alert_type")
                .setStatus(Status.ABORTED)
                .setState(State.COMPLETED)
                .build();

        var actual = expect.toBuilder().build();
        assertEquals(expect, actual);
    }
}
