package ru.yandex.solomon.scheduler.dao.ydb;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;

import ru.yandex.devtools.test.annotations.YaExternal;
import ru.yandex.solomon.kikimr.LocalKikimr;
import ru.yandex.solomon.kikimr.YdbHelper;
import ru.yandex.solomon.scheduler.dao.SchedulerDao;
import ru.yandex.solomon.scheduler.dao.SchedulerDaoTest;

/**
 * @author Vladimir Gordiychuk
 */
@YaExternal
public class YdbSchedulerDaoTest extends SchedulerDaoTest {
    @ClassRule
    public static LocalKikimr kikimr = new LocalKikimr();

    @Rule
    public TestName testName = new TestName();
    private SchedulerDao dao;

    @Before
    public void setUp() {
        var ydb = new YdbHelper(kikimr, this.getClass().getSimpleName() + "_" + testName.getMethodName());
        var root = ydb.getRootPath();

        dao = new YdbSchedulerDao(root, ydb.getTableClient(), ydb.getSchemeClient());
        dao.createSchema().join();
    }

    @Override
    protected SchedulerDao getDao() {
        return dao;
    }
}
