package ru.yandex.solomon.scheduler.grpc;

import org.junit.Test;

import ru.yandex.solomon.scheduler.Task;
import ru.yandex.solomon.scheduler.Task.State;

import static org.junit.Assert.assertEquals;
import static ru.yandex.solomon.scheduler.handlers.Tasks.anyAsNumber;
import static ru.yandex.solomon.scheduler.handlers.Tasks.randomTask;

/**
 * @author Vladimir Gordiychuk
 */
public class ProtoTest {

    @Test
    public void scheduled() {
        var task = randomTask();
        assertProtoAndBack(task);
    }

    @Test
    public void completed() {
        var task = randomTask().toBuilder()
                .setState(State.COMPLETED)
                .setResult(anyAsNumber())
                .build();

        assertProtoAndBack(task);
    }

    @Test
    public void running() {
        var task = randomTask().toBuilder()
                .setState(State.RUNNING)
                .setProgress(anyAsNumber())
                .build();

        assertProtoAndBack(task);
    }

    private void assertProtoAndBack(Task task) {
        var proto = Proto.toProto(task);
        var result = Proto.fromProto(proto);
        assertEquals(task, result);
    }
}
