package ru.yandex.solomon.scheduler.handlers;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Any;
import com.google.protobuf.Descriptors.Descriptor;

import ru.yandex.solomon.scheduler.ExecutionContext;
import ru.yandex.solomon.scheduler.Permit;
import ru.yandex.solomon.scheduler.TaskHandler;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class ContextTaskHandler implements TaskHandler {
    private static final ConcurrentMap<String, CompletableFuture<ExecutionContext>> contextByTaskId = new ConcurrentHashMap<>();

    @Override
    public String type() {
        return "context";
    }

    @Override
    @Nullable
    public Permit acquire(String id, Any params) {
        return Permits.acquire();
    }

    @Override
    public void execute(ExecutionContext context) {
        var task = context.task();
        contextByTaskId(task.id()).completeAsync(() -> context);
    }

    @Override
    public List<Descriptor> descriptors() {
        return List.of();
    }

    public static CompletableFuture<ExecutionContext> contextByTaskId(String taskId) {
        return contextByTaskId.computeIfAbsent(taskId, ignore -> new CompletableFuture<>());
    }

    public static void clear(String taskId) {
        contextByTaskId.remove(taskId);
    }

    public static void clear() {
        contextByTaskId.clear();
    }
}
