package ru.yandex.solomon.scheduler.handlers;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Any;
import com.google.protobuf.Descriptors.Descriptor;

import ru.yandex.solomon.scheduler.ExecutionContext;
import ru.yandex.solomon.scheduler.Permit;
import ru.yandex.solomon.scheduler.TaskHandler;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class FutureTaskHandler implements TaskHandler {
    private static final ConcurrentMap<String, CompletableFuture<Any>> resultByTaskId = new ConcurrentHashMap<>();

    @Override
    public String type() {
        return "future";
    }

    @Override
    @Nullable
    public Permit acquire(String id, Any params) {
        return Permits.acquire();
    }

    @Override
    public void execute(ExecutionContext context) {
        var task = context.task();
        futureByTaskId(task.id()).whenComplete((result, e) -> {
            if (e != null) {
                context.fail(e);
            } else {
                context.complete(result);
            }
        });
    }

    @Override
    public List<Descriptor> descriptors() {
        return List.of();
    }

    public static CompletableFuture<Any> futureByTaskId(String taskId) {
        return resultByTaskId.computeIfAbsent(taskId, ignore -> new CompletableFuture<>());
    }
}
