package ru.yandex.solomon.scheduler.handlers;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Any;
import com.google.protobuf.Descriptors.Descriptor;
import com.google.protobuf.Int32Value;
import com.google.protobuf.StringValue;

import ru.yandex.solomon.scheduler.ExecutionContext;
import ru.yandex.solomon.scheduler.Permit;
import ru.yandex.solomon.scheduler.TaskHandler;
import ru.yandex.solomon.util.Proto;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class NumberTaskHandler implements TaskHandler {
    private final AtomicInteger state = new AtomicInteger();

    public NumberTaskHandler() {
    }

    @Override
    public String type() {
        return "number";
    }

    @Override
    @Nullable
    public Permit acquire(String id, Any params) {
        return Permits.acquire();
    }

    @Override
    public void execute(ExecutionContext context) {
        var command = Proto.unpack(context.task().params(), StringValue.class).getValue();
        context.complete(Proto.pack(Int32Value.of(exec(command))));
    }

    @Override
    public List<Descriptor> descriptors() {
        return List.of(Int32Value.getDescriptor());
    }

    private int exec(String command) {
        return switch (command) {
            case "inc" -> state.incrementAndGet();
            case "dec" -> state.decrementAndGet();
            case "get" -> state.get();
            default -> throw new IllegalArgumentException("unknown command: " + command);
        };
    }
}
