package ru.yandex.solomon.scheduler.handlers;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

import ru.yandex.solomon.scheduler.Permit;

/**
 * @author Vladimir Gordiychuk
 */
public class Permits {
    public static volatile Permits INSTANCE = new Permits(Integer.MAX_VALUE, new CountDownLatch(1));
    public final CountDownLatch onRelease;
    private final AtomicInteger count;

    public Permits(int count, CountDownLatch onRelease) {
        this.count = new AtomicInteger(count);
        this.onRelease = onRelease;
    }

    public static Permit acquire() {
        return INSTANCE.acquireImpl();
    }

    public static void clear() {
        INSTANCE = new Permits(Integer.MAX_VALUE, new CountDownLatch(1));
    }

    public Permit acquireImpl() {
        int prev = count.get();
        do {
            if (prev == 0) {
                return null;
            }
        } while (count.compareAndSet(prev, prev - 1));
        return new PermitImpl();
    }

    public int available() {
        return count.get();
    }

    private class PermitImpl implements Permit {
        private final AtomicBoolean done = new AtomicBoolean();

        @Override
        public void cancel() {
            release();
        }

        @Override
        public void release() {
            if (done.compareAndSet(false, true)) {
                count.incrementAndGet();
                onRelease.countDown();
            } else {
                throw new IllegalStateException("already released");
            }
        }
    }
}
