package ru.yandex.solomon.scheduler.handlers;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Any;
import com.google.protobuf.Descriptors.Descriptor;
import com.google.protobuf.StringValue;

import ru.yandex.solomon.scheduler.ExecutionContext;
import ru.yandex.solomon.scheduler.Permit;
import ru.yandex.solomon.scheduler.TaskHandler;
import ru.yandex.solomon.util.Proto;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class StringTaskHandler implements TaskHandler {
    private final AtomicReference<String> state = new AtomicReference<>("");

    @Override
    public String type() {
        return "string";
    }

    @Override
    @Nullable
    public Permit acquire(String id, Any params) {
        return Permits.acquire();
    }

    @Override
    public void execute(ExecutionContext context) {
        var command = Proto.unpack(context.task().params(), StringValue.class).getValue();
        context.complete(Proto.pack(StringValue.of(exec(command))));
    }

    @Override
    public List<Descriptor> descriptors() {
        return List.of(StringValue.getDescriptor());
    }

    private String exec(String command) {
        String prev = state.get();
        String update;
        do {
            if (prev.isEmpty()) {
                update = command;
            } else {
                update = prev + "|" + command;
            }
        } while (!state.compareAndSet(prev, update));
        return update;
    }
}
