package ru.yandex.solomon.exception.handlers;

import java.util.Map;

import io.grpc.Status;
import org.springframework.http.HttpStatus;

/**
 * @author Oleg Baryshnikov
 */
public class ExceptionData {
    private final Status.Code grpcStatus;
    private final HttpStatus httpStatus;
    private final String message;
    private final Map<String, String> headers;
    private final Map<String, Object> attrs;

    public ExceptionData(
            Status.Code grpcStatus,
            HttpStatus httpStatus,
            String message,
            Map<String, String> headers,
            Map<String, Object> attrs) {
        this.grpcStatus = grpcStatus;
        this.httpStatus = httpStatus;
        this.message = message;
        this.headers = headers;
        this.attrs = attrs;
    }

    public Status.Code getGrpcStatus() {
        return grpcStatus;
    }

    public HttpStatus getHttpStatus() {
        return httpStatus;
    }

    public String getMessage() {
        return message;
    }

    public Map<String, String> getHeaders() {
        return headers;
    }

    public Map<String, Object> getAttrs() {
        return attrs;
    }
}
