package ru.yandex.solomon.exception.handlers;

import javax.annotation.ParametersAreNonnullByDefault;

import io.grpc.Context;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.grpc.utils.RequestParamsInterceptor;
import ru.yandex.misc.concurrent.CompletableFutures;


/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class GrpcApiExceptionResolver {
    private static final Logger logger = LoggerFactory.getLogger(GrpcApiExceptionResolver.class);

    public static StatusRuntimeException doResolveException(Throwable throwable) {
        Context context = Context.current();
        String methodName = RequestParamsInterceptor.getMethodName(context);
        String requestId = RequestParamsInterceptor.getRequestId(context);
        String userIp = RequestParamsInterceptor.getUserIp(context);

        Throwable cause = CompletableFutures.unwrapCompletionException(throwable);

        boolean isInternalApi = methodName == null || !methodName.contains("cloud");

        ExceptionData exceptionData = CommonApiExceptionHandler.tryHandleSolomonException(cause, requestId, isInternalApi);

        String message = exceptionData.getMessage();
        String logMessage = "gRPC server error, method: " + methodName +
                        (StringUtils.isEmpty(requestId) ? "" : ", requestId: " + requestId) +
                        ", ip: " + userIp +
                        ", status: " + exceptionData.getGrpcStatus() +
                        ", message: " + message;

        logger.error(logMessage, cause);

        Status status = exceptionData.getGrpcStatus().toStatus().withDescription(message);

        return new StatusRuntimeException(status);
    }
}
