package ru.yandex.solomon.expression;

import java.util.stream.Stream;

/**
 * @author Stepan Koltsov
 */
public enum MetricPrefix {
    KILO("k", 1000L),
    MEGA("M", 1000L * 1000),
    GIGA("G", 1000L * 1000 * 1000),
    TERA("T", 1000L * 1000 * 1000 * 1000),
    PETA("P", 1000L * 1000 * 1000 * 1000 * 1000),
    EXA("E", 1000L * 1000 * 1000 * 1000 * 1000 * 1000),
    ;
    private final String letter;
    private final long multiplier;

    MetricPrefix(String letter, long multiplier) {
        this.letter = letter;
        this.multiplier = multiplier;
    }

    public long getMultiplier() {
        return multiplier;
    }

    public static MetricPrefix byLetter(String letter) {
        return Stream.of(values())
                .filter(m -> m.letter.equals(letter))
                .findAny()
                .orElseThrow(() -> new RuntimeException("unknown prefix: " + letter));
    }
}
