package ru.yandex.solomon.expression.analytics;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.NamedGraphData;

/**
 * @author Maksim Leonov
 */
@ParametersAreNonnullByDefault
public interface GraphDataLoader {
    NamedGraphData[] loadGraphData(GraphDataLoadRequest request);

    /* Downsampling grid associated with load requests, 0 if unknown */
    default long getSeriesGridMillis() {
        return 0;
    }

    static GraphDataLoader empty() {
        return request -> { throw new RuntimeException("empty resolver"); };
    }
}
