package ru.yandex.solomon.expression.analytics;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.expr.IntrinsicsExternalizer;
import ru.yandex.solomon.expression.expr.SideEffectProcessor;
import ru.yandex.solomon.util.time.Interval;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class PrepareContext {

    private final Interval interval;
    private final IntrinsicsExternalizer externalizer;
    private final SideEffectProcessor sideEffectProcessor;

    public Interval getInterval() {
        return interval;
    }

    public IntrinsicsExternalizer getExternalizer() {
        return externalizer;
    }

    public SideEffectProcessor getSideEffectProcessor() {
        return sideEffectProcessor;
    }

    private PrepareContext(Interval interval, IntrinsicsExternalizer externalizer,
                           SideEffectProcessor sideEffectProcessor) {
        this.interval = interval;
        this.externalizer = externalizer;
        this.sideEffectProcessor = sideEffectProcessor;
    }

    public static Builder onInterval(Interval interval) {
        return new Builder(interval);
    }

    @ParametersAreNonnullByDefault
    public static class Builder {
        final Interval interval;
        @Nullable
        IntrinsicsExternalizer externalizer = null;
        SideEffectProcessor sideEffectProcessor = SideEffectProcessor.throwing();

        private Builder(Interval interval) {
            this.interval = interval;
        }

        public Builder withExternalizer(IntrinsicsExternalizer externalizer) {
            this.externalizer = externalizer;
            return this;
        }

        public Builder withSideEffectsProcessor(SideEffectProcessor sideEffectsProcessor) {
            this.sideEffectProcessor = sideEffectsProcessor;
            return this;
        }

        public PrepareContext build() {
            if (externalizer == null) {
                externalizer = IntrinsicsExternalizer.newBuilder(interval).build();
            }
            return new PrepareContext(interval, externalizer, sideEffectProcessor);
        }
    }
}
