package ru.yandex.solomon.expression.analytics;

import java.util.HashMap;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.base.Joiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.solomon.expression.SelParser;
import ru.yandex.solomon.expression.ast.Ast;
import ru.yandex.solomon.expression.ast.AstAssignment;
import ru.yandex.solomon.expression.ast.AstStatement;
import ru.yandex.solomon.expression.compile.DeprOpts;
import ru.yandex.solomon.expression.type.SelType;
import ru.yandex.solomon.expression.type.SelTypes;
import ru.yandex.solomon.expression.version.SelVersion;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
class ProgramCompiler extends AbstractCompiler {
    private static final Logger logger = LoggerFactory.getLogger(ProgramCompiler.class);

    ProgramCompiler(SelVersion version, String src) {
        super(version, src);
        this.withDeprOpts(DeprOpts.DEFAULT);
        this.useNewFormat(false);
    }

    @Override
    public Program compileInternal() {
        HashMap<String, SelType> contextData = new HashMap<>();
        selectors.forEach((k, v) -> contextData.put(k, SelTypes.STRING));
        HashMap<String, String> expressionsToVariableNames = new HashMap<>();

        List<AstStatement> statements = new SelParser(source).parseBlock();

        for (String expression : externalExpressions) {
            String elementVarName = "external$" + statements.size();
            Ast elementExpression = new SelParser(expression).parseExpr();
            expressionsToVariableNames.put(expression, elementVarName);

            AstAssignment assignment = new AstAssignment(elementExpression.getRange(), elementVarName, elementExpression);
            statements.add(assignment);
        }

        if (logger.isDebugEnabled()) {
            logger.debug("Prepared program AST:\n{}", Joiner.on("\n").join(statements));
        }

        return compileStatements(statements, expressionsToVariableNames, contextData);
    }
}
